<?php
header("Content-Type: application/json");

$TIMEOUT = 60; // hanya untuk status
$now = time();

$result = [];
$offline = [];

/* default awal (jika BELUM PERNAH ADA DATA) */
for ($i = 1; $i <= 14; $i++) {
    $result[(string)$i] = "4";
}

$files = glob(__DIR__ . "/data/lokasi*.json");

foreach ($files as $file) {
    $lokasi = basename($file, ".json");
    $json = json_decode(file_get_contents($file), true);

    /* validasi struktur */
    if (!isset($json["data"], $json["last_update"])) {
        $offline[] = $lokasi;
        continue;
    }

    /* 1️⃣ SELALU PAKAI DATA */
    foreach ($json["data"] as $k => $v) {
        if (is_numeric($k) && is_numeric($v)) {
            $result[(string)$k] = (string)$v;
        }
    }

    /* 2️⃣ CEK OFFLINE (TIDAK PENGARUHI DATA) */
    if (($now - $json["last_update"]) > $TIMEOUT) {
        $offline[] = $lokasi;
    }
}

/* info status */
if (!empty($offline)) {
    $result["_offline"] = $offline;
}

echo json_encode($result, JSON_PRETTY_PRINT);
