// ===============================
// TANK NAME MAP
// ===============================
const tankNames = {
  1: "dormitory-a",
  2: "dormitory-b1",
  3: "dormitory-b2",
  4: "dormitory-c1",
  5: "dormitory-c2",
  6: "dormitory-c3",
  7: "classroom-4",
  8: "recectory",
  9: "main-building",
  10: "engine-room",
  11: "simulator-1",
  12: "simulator-2",
  13: "simulator-3",
  14: "laboratorium"
};

// ===============================
// LEVEL MAP
// ===============================
const levelMap = {
  "0": 0,
  "1": 25,
  "2": 50,
  "3": 75,
  "4": 100
};

// ===============================
// GLOBAL STATE
// ===============================
let config = [];
let inputState = {};

// ===============================
// ALARM
// ===============================
const alarmAudio = new Audio("alarm.mp3");
alarmAudio.loop = true;
let alarmActive = false;
let soundEnabled = false;

// 1x klik di layar untuk unlock audio (aturan browser)
document.addEventListener(
  "click",
  () => {
    if (soundEnabled) return;
    alarmAudio
      .play()
      .then(() => {
        alarmAudio.pause();
        alarmAudio.currentTime = 0;
        soundEnabled = true;
        console.log("Alarm sound enabled");
      })
      .catch(() => {});
  },
  { once: true }
);

// ===============================
// LOAD DATA (MERGE.PHP)
// ===============================
async function loadData() {
  try {
    config = await (await fetch("config.json")).json();
    inputState = await (await fetch("merge.php?c=" + Date.now())).json();
    drawValves();
    checkAlarm();
  } catch (e) {
    console.error("Load error:", e);
  }
}

// refresh tiap 1 detik
setInterval(loadData, 1000);

// ===============================
// DRAW ICONS
// ===============================
function drawValves() {
  const bg = document.getElementById("background");
  const wrap = document.getElementById("wrapper");
  if (!bg || !wrap) return;

  document.querySelectorAll(".valve").forEach((e) => e.remove());

  const bgRect = bg.getBoundingClientRect();
  const wrapRect = wrap.getBoundingClientRect();

  config.forEach((btn) => {
    const icon = document.createElement("img");
    icon.className = "valve";

    const code = inputState[String(btn.id)] ?? "4"; // default aman
    const level = levelMap[code] ?? 100;
    const name = tankNames[btn.id];

    icon.src = `icons/${name}-${level}.png`;

    const x = bgRect.left + btn.x * bgRect.width;
    const y = bgRect.top + btn.y * bgRect.height;
    const w = btn.width * bgRect.width;
    const h = btn.height * bgRect.height;

    icon.style.left = x - wrapRect.left - w / 2 + "px";
    icon.style.top = y - wrapRect.top - h / 2 + "px";
    icon.style.width = w + "px";
    icon.style.height = h + "px";

    wrap.appendChild(icon);
  });
}

// ===============================
// CHECK ALARM
// ===============================
function checkAlarm() {
  if (!soundEnabled) return;

  let alarm = false;

  for (const id in inputState) {
    if (inputState[id] === "0" || inputState[id] === "1") {
      alarm = true;
      break;
    }
  }

  if (alarm && !alarmActive) {
    alarmAudio.play().catch(() => {});
    alarmActive = true;
  }

  if (!alarm && alarmActive) {
    alarmAudio.pause();
    alarmAudio.currentTime = 0;
    alarmActive = false;
  }
}

// ===============================
// INIT
// ===============================
loadData();
