<?php
header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);
if (!is_array($data)) {
    http_response_code(400);
    echo json_encode(["status"=>"error","msg"=>"invalid json"]);
    exit;
}

/* validasi level 0–4 */
foreach ($data as $k => $v) {
    if (!is_numeric($v) || $v < 0 || $v > 4) {
        http_response_code(400);
        echo json_encode(["status"=>"error","msg"=>"invalid value"]);
        exit;
    }
}

file_put_contents(
    __DIR__ . "/data/lokasi8.json",
    json_encode([
        "data" => $data,
        "last_update" => time()
    ], JSON_PRETTY_PRINT)
);

echo json_encode(["status"=>"ok"]);
